# 2d: Older cohorts save more of inheritance
# Cohorts aged 55 and over who receive an inheritance save their inheritance in other assets at double the saving rate of income in other assets.

gc()


# Read in base params ---------------------------------------------

## starting cohort pathways (from step 3)
starting_cohorts_pathways <- qread(starting_cohorts_pathways_file)



# Adjust for scenario -----------------------------------------------------

bequest_other_asset_saving <- starting_cohorts_pathways %>% 
  distinct(age_grp, total_inc_qtile, ho, bequest_other_asset_saving_param) %>% 
  mutate(bequest_other_asset_saving_param_adj = ifelse(age_grp>="[55,60)",
                                                       bequest_other_asset_saving_param*2, ## double rate
                                                       bequest_other_asset_saving_param),
         bequest_other_asset_saving_param_adj = ifelse(bequest_other_asset_saving_param_adj>1, 1, bequest_other_asset_saving_param_adj))

  
  
# Put into new version of starting_cohorts, convert to year list and save --------


starting_cohorts_pathways_adj <- starting_cohorts_pathways %>% 
  left_join(bequest_other_asset_saving) %>% 
  ## replace values
  select( -bequest_other_asset_saving_param, bequest_other_asset_saving_param = bequest_other_asset_saving_param_adj)


## split into list by year - save for use in model running
year_list_0 <- starting_cohorts_pathways_adj %>% 
  split(., .$year) 

qsave(year_list_0, "./Output data/year_list_0_increase_bequest_saving.qs")